

<?php $__env->startSection('title', 'Orders'); ?>
<?php $__env->startSection('page-title', 'Orders'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Orders</h3>
            <div>
                <a href="<?php echo e(route('orders.returns')); ?>" class="btn btn-warning me-2">
                    <i class="fas fa-undo me-2"></i>View Returns
                </a>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create-orders')): ?>
                <a href="<?php echo e(route('orders.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Order
                </a>
                <?php endif; ?>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Order ID</th>
                        <th>Customer</th>
                        <th>Email</th>
                        <th>Total Amount</th>
                        <th>Shipping</th>
                        <th>GST</th>
                        <th>WH Inc.Tax</th>
                        <th>WH Sales.Tax</th>
                        <th>Net Amount</th>
                        <th>Status</th>
                        <th>Order Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($order->shopify_order_id); ?></td>
                            <td><?php echo e($order->customer_name); ?></td>
                            <td><?php echo e($order->customer_email ?: 'N/A'); ?></td>
                            <td>Rs.<?php echo e(number_format($order->total_amount, 2)); ?></td>
                            <td>
                                <?php if($order->shipping_charges): ?>
                                    <span class="text-success">Rs.<?php echo e(number_format($order->shipping_charges, 2)); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($order->gst): ?>
                                    <span class="text-danger">Rs.<?php echo e(number_format($order->gst, 2)); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($order->wh_inc_tax): ?>
                                    <span class="text-danger">Rs.<?php echo e(number_format($order->wh_inc_tax, 2)); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($order->wh_sales_tax): ?>
                                    <span class="text-danger">Rs.<?php echo e(number_format($order->wh_sales_tax, 2)); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($order->net_amount): ?>
                                    <strong class="text-primary">Rs.<?php echo e(number_format($order->net_amount, 2)); ?></strong>
                                    <?php if($order->courier_data_updated_at): ?>
                                        <br><small class="text-muted" title="Last updated: <?php echo e($order->courier_data_updated_at->format('M d, Y H:i')); ?>">
                                            <i class="fas fa-check-circle text-success"></i> Updated
                                        </small>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-warning">
                                        <i class="fas fa-clock"></i> Pending
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($order->returned_at): ?>
                                    <span class="badge bg-danger">
                                        <i class="fas fa-undo me-1"></i>Returned
                                    </span>
                                    <br><small class="text-muted"><?php echo e($order->returned_at->format('M d, Y')); ?></small>
                                <?php else: ?>
                                    <span class="badge bg-<?php echo e($order->status === 'pending' ? 'warning' : ($order->status === 'processing' ? 'info' : ($order->status === 'delivered' ? 'success' : 'secondary'))); ?>">
                                        <?php echo e(ucfirst($order->status)); ?>

                                    </span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($order->order_date->format('M d, Y')); ?></td>
                            <td>
                                <a href="<?php echo e(route('orders.show', $order)); ?>" class="btn btn-sm btn-outline-primary">View</a>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-orders')): ?>
                                <a href="<?php echo e(route('orders.edit', $order)); ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-orders')): ?>
                                <form method="POST" action="<?php echo e(route('orders.destroy', $order)); ?>" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this order?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="12" class="text-center">No orders found. 
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create-orders')): ?>
                                <a href="<?php echo e(route('orders.create')); ?>">Add some orders</a> or 
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('import-inventory')): ?>
                                <a href="<?php echo e(route('import.index')); ?>">import from Excel</a> to get started.
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php echo e($orders->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\jtest\resources\views/orders/index.blade.php ENDPATH**/ ?>