

<?php $__env->startSection('title', 'Simple Report'); ?>
<?php $__env->startSection('page-title', 'Simple Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header with Date Filter -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-table me-2"></i>Orders Report</h5>
                        <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-chart-line me-2"></i>View Dashboard
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('reports.simple')); ?>" id="filterForm">
                        <div class="row align-items-end">
                            <div class="col-md-3">
                                <label for="filter_type" class="form-label"><strong>Period</strong></label>
                                <select name="filter_type" id="filter_type" class="form-select" onchange="toggleCustomDates()">
                                    <option value="daily" <?php echo e($filterType == 'daily' ? 'selected' : ''); ?>>Today</option>
                                    <option value="weekly" <?php echo e($filterType == 'weekly' ? 'selected' : ''); ?>>This Week</option>
                                    <option value="monthly" <?php echo e($filterType == 'monthly' ? 'selected' : ''); ?>>This Month</option>
                                    <option value="yearly" <?php echo e($filterType == 'yearly' ? 'selected' : ''); ?>>This Year</option>
                                    <option value="custom" <?php echo e($filterType == 'custom' ? 'selected' : ''); ?>>Custom Range</option>
                                </select>
                            </div>
                            
                            <div class="col-md-3" id="start_date_container" style="display: <?php echo e($filterType == 'custom' ? 'block' : 'none'); ?>;">
                                <label for="start_date" class="form-label"><strong>Start Date</strong></label>
                                <input type="date" name="start_date" id="start_date" class="form-control" value="<?php echo e($startDate); ?>">
                            </div>
                            
                            <div class="col-md-3" id="end_date_container" style="display: <?php echo e($filterType == 'custom' ? 'block' : 'none'); ?>;">
                                <label for="end_date" class="form-label"><strong>End Date</strong></label>
                                <input type="date" name="end_date" id="end_date" class="form-control" value="<?php echo e($endDate); ?>">
                            </div>
                            
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-filter me-2"></i>Apply Filter
                                </button>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="alert alert-info mb-0">
                                    <i class="fas fa-calendar me-2"></i>
                                    <strong>Viewing:</strong> <?php echo e($dateRange['label']); ?> | 
                                    <strong>Orders:</strong> <?php echo e($totals['orders_count']); ?> | 
                                    <strong>Items:</strong> <?php echo e($totals['total_items']); ?>

                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Orders List</h5>
                </div>
                <div class="card-body">
                    <?php if($orders->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover">
                                <thead class="table-dark">
                                    <tr>
                                        <th>#</th>
                                        <th>Order Date</th>
                                        <th>Order ID</th>
                                        <th>Customer</th>
                                        <th class="text-end">Items</th>
                                        <th class="text-end">Gross Sales</th>
                                        <th class="text-end">Shipping</th>
                                        <th class="text-end">GST</th>
                                        <th class="text-end">WH Inc.Tax</th>
                                        <th class="text-end">WH Sales Tax</th>
                                        <th class="text-end">Net Revenue</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td><?php echo e($order->order_date->format('M d, Y')); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('orders.show', $order)); ?>">
                                                    <?php echo e($order->shopify_order_id); ?>

                                                </a>
                                            </td>
                                            <td><?php echo e($order->customer_name); ?></td>
                                            <td class="text-end"><?php echo e($order->orderItems->sum('quantity')); ?></td>
                                            <td class="text-end">Rs.<?php echo e(number_format($order->total_amount, 2)); ?></td>
                                            <td class="text-end">
                                                <?php if($order->shipping_charges): ?>
                                                    <span class="text-danger">Rs.<?php echo e(number_format($order->shipping_charges, 2)); ?></span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end">
                                                <?php if($order->gst): ?>
                                                    <span class="text-danger">Rs.<?php echo e(number_format($order->gst, 2)); ?></span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end">
                                                <?php if($order->wh_inc_tax): ?>
                                                    <span class="text-danger">Rs.<?php echo e(number_format($order->wh_inc_tax, 2)); ?></span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end">
                                                <?php if($order->wh_sales_tax): ?>
                                                    <span class="text-danger">Rs.<?php echo e(number_format($order->wh_sales_tax, 2)); ?></span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end">
                                                <?php if($order->net_amount): ?>
                                                    <strong class="text-primary">Rs.<?php echo e(number_format($order->net_amount, 2)); ?></strong>
                                                <?php else: ?>
                                                    <?php
                                                        $calculated = $order->total_amount - ($order->shipping_charges ?? 0) - ($order->gst ?? 0) - ($order->wh_inc_tax ?? 0) - ($order->wh_sales_tax ?? 0);
                                                    ?>
                                                    <strong class="text-primary">Rs.<?php echo e(number_format($calculated, 2)); ?></strong>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <!-- Totals Row -->
                                <tfoot class="table-secondary">
                                    <tr>
                                        <th colspan="4" class="text-end">
                                            <strong>TOTALS (<?php echo e($totals['orders_count']); ?> Orders)</strong>
                                        </th>
                                        <th class="text-end">
                                            <strong><?php echo e($totals['total_items']); ?></strong>
                                        </th>
                                        <th class="text-end">
                                            <strong>Rs.<?php echo e(number_format($totals['gross_sales'], 2)); ?></strong>
                                        </th>
                                        <th class="text-end">
                                            <strong class="text-danger">Rs.<?php echo e(number_format($totals['shipping'], 2)); ?></strong>
                                        </th>
                                        <th class="text-end">
                                            <strong class="text-danger">Rs.<?php echo e(number_format($totals['gst'], 2)); ?></strong>
                                        </th>
                                        <th class="text-end">
                                            <strong class="text-danger">Rs.<?php echo e(number_format($totals['wh_inc_tax'], 2)); ?></strong>
                                        </th>
                                        <th class="text-end">
                                            <strong class="text-danger">Rs.<?php echo e(number_format($totals['wh_sales_tax'], 2)); ?></strong>
                                        </th>
                                        <th class="text-end">
                                            <strong class="text-primary fs-5">Rs.<?php echo e(number_format($totals['net_revenue'], 2)); ?></strong>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        <!-- Summary Card -->
                        <div class="row mt-4">
                            <div class="col-md-6 offset-md-6">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">Summary</h6>
                                        <table class="table table-sm mb-0">
                                            <tr>
                                                <td><strong>Gross Sales (COD Collected):</strong></td>
                                                <td class="text-end"><strong>Rs.<?php echo e(number_format($totals['gross_sales'], 2)); ?></strong></td>
                                            </tr>
                                            <tr class="border-top">
                                                <td colspan="2" class="text-danger"><strong>Courier Deductions:</strong></td>
                                            </tr>
                                            <tr class="text-danger">
                                                <td>- Shipping Charges:</td>
                                                <td class="text-end"><strong>Rs.<?php echo e(number_format($totals['shipping'], 2)); ?></strong></td>
                                            </tr>
                                            <tr class="text-danger">
                                                <td>- GST:</td>
                                                <td class="text-end"><strong>Rs.<?php echo e(number_format($totals['gst'], 2)); ?></strong></td>
                                            </tr>
                                            <tr class="text-danger">
                                                <td>- WH Inc.Tax:</td>
                                                <td class="text-end"><strong>Rs.<?php echo e(number_format($totals['wh_inc_tax'], 2)); ?></strong></td>
                                            </tr>
                                            <tr class="text-danger">
                                                <td>- WH Sales Tax:</td>
                                                <td class="text-end"><strong>Rs.<?php echo e(number_format($totals['wh_sales_tax'], 2)); ?></strong></td>
                                            </tr>
                                            <tr class="border-top">
                                                <td><strong>Total Deductions:</strong></td>
                                                <td class="text-end text-danger"><strong>Rs.<?php echo e(number_format($totals['shipping'] + $totals['gst'] + $totals['wh_inc_tax'] + $totals['wh_sales_tax'], 2)); ?></strong></td>
                                            </tr>
                                            <tr class="bg-success bg-opacity-25 border-top border-2">
                                                <td><strong class="fs-5">NET REVENUE:</strong></td>
                                                <td class="text-end text-primary"><strong class="fs-5">Rs.<?php echo e(number_format($totals['net_revenue'], 2)); ?></strong></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            No orders found for the selected period.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function toggleCustomDates() {
    const filterType = document.getElementById('filter_type').value;
    const startContainer = document.getElementById('start_date_container');
    const endContainer = document.getElementById('end_date_container');
    
    if (filterType === 'custom') {
        startContainer.style.display = 'block';
        endContainer.style.display = 'block';
    } else {
        startContainer.style.display = 'none';
        endContainer.style.display = 'none';
    }
}
</script>

<style>
.table-responsive {
    max-height: 70vh;
    overflow-y: auto;
}

.table thead th {
    position: sticky;
    top: 0;
    z-index: 10;
}

.table tfoot th {
    position: sticky;
    bottom: 0;
    z-index: 10;
}
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\jtest\resources\views/reports/simple.blade.php ENDPATH**/ ?>