

<?php $__env->startSection('title', 'Reports & Analytics'); ?>
<?php $__env->startSection('page-title', 'Reports & Analytics'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header with Date Filter -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-chart-line me-2"></i>Business Reports & P&L Analysis</h5>
                        <a href="<?php echo e(route('reports.simple')); ?>" class="btn btn-light btn-sm">
                            <i class="fas fa-table me-2"></i>Simple Table View
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('reports.index')); ?>" id="filterForm">
                        <div class="row align-items-end">
                            <div class="col-md-3">
                                <label for="filter_type" class="form-label"><strong>Report Period</strong></label>
                                <select name="filter_type" id="filter_type" class="form-select" onchange="toggleCustomDates()">
                                    <option value="daily" <?php echo e($filterType == 'daily' ? 'selected' : ''); ?>>Today</option>
                                    <option value="weekly" <?php echo e($filterType == 'weekly' ? 'selected' : ''); ?>>This Week</option>
                                    <option value="monthly" <?php echo e($filterType == 'monthly' ? 'selected' : ''); ?>>This Month</option>
                                    <option value="yearly" <?php echo e($filterType == 'yearly' ? 'selected' : ''); ?>>This Year</option>
                                    <option value="custom" <?php echo e($filterType == 'custom' ? 'selected' : ''); ?>>Custom Range</option>
                                </select>
                            </div>
                            
                            <div class="col-md-3" id="start_date_container" style="display: <?php echo e($filterType == 'custom' ? 'block' : 'none'); ?>;">
                                <label for="start_date" class="form-label"><strong>Start Date</strong></label>
                                <input type="date" name="start_date" id="start_date" class="form-control" value="<?php echo e($startDate); ?>">
                            </div>
                            
                            <div class="col-md-3" id="end_date_container" style="display: <?php echo e($filterType == 'custom' ? 'block' : 'none'); ?>;">
                                <label for="end_date" class="form-label"><strong>End Date</strong></label>
                                <input type="date" name="end_date" id="end_date" class="form-control" value="<?php echo e($endDate); ?>">
                            </div>
                            
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-filter me-2"></i>Apply Filter
                                </button>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="alert alert-info mb-0">
                                    <i class="fas fa-calendar me-2"></i>
                                    <strong>Viewing:</strong> <?php echo e($dateRange['label']); ?>

                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Key Metrics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-success bg-opacity-10 border-success h-100">
                <div class="card-body text-center">
                    <i class="fas fa-dollar-sign fa-2x text-success mb-2"></i>
                    <h3 class="text-success mb-1">Rs.<?php echo e(number_format($metrics['net_revenue'], 2)); ?></h3>
                    <p class="mb-0 text-muted small"><strong>Net Revenue</strong></p>
                    <small class="text-muted">After all deductions</small>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card bg-primary bg-opacity-10 border-primary h-100">
                <div class="card-body text-center">
                    <i class="fas fa-shopping-cart fa-2x text-primary mb-2"></i>
                    <h3 class="text-primary mb-1"><?php echo e($metrics['total_orders']); ?></h3>
                    <p class="mb-0 text-muted small"><strong>Total Orders</strong></p>
                    <small class="text-muted"><?php echo e($metrics['total_items']); ?> items sold</small>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card bg-info bg-opacity-10 border-info h-100">
                <div class="card-body text-center">
                    <i class="fas fa-chart-line fa-2x text-info mb-2"></i>
                    <h3 class="text-info mb-1">Rs.<?php echo e(number_format($metrics['avg_order_value'], 2)); ?></h3>
                    <p class="mb-0 text-muted small"><strong>Avg Order Value</strong></p>
                    <small class="text-muted">Per transaction</small>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card bg-warning bg-opacity-10 border-warning h-100">
                <div class="card-body text-center">
                    <i class="fas fa-undo fa-2x text-warning mb-2"></i>
                    <h3 class="text-warning mb-1"><?php echo e($metrics['returned_count']); ?></h3>
                    <p class="mb-0 text-muted small"><strong>Returns</strong></p>
                    <small class="text-muted"><?php echo e(number_format($metrics['return_rate'], 1)); ?>% rate</small>
                </div>
            </div>
        </div>
    </div>

    <!-- P&L Statement -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0"><i class="fas fa-file-invoice-dollar me-2"></i>Profit & Loss Statement</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless mb-0">
                        <tbody>
                            <!-- Revenue Section -->
                            <tr class="border-bottom">
                                <td colspan="2" class="fw-bold text-primary">REVENUE</td>
                            </tr>
                            <tr>
                                <td class="ps-4"><strong>Gross Sales (COD Collected)</strong></td>
                                <td class="text-end"><strong>Rs.<?php echo e(number_format($metrics['gross_sales'], 2)); ?></strong></td>
                            </tr>
                            
                            <!-- Deductions Section -->
                            <tr class="border-top border-bottom">
                                <td colspan="2" class="fw-bold text-danger pt-3">COURIER DEDUCTIONS</td>
                            </tr>
                            <tr>
                                <td class="ps-4 text-danger">Less: Shipping Charges (Courier Fee)</td>
                                <td class="text-end text-danger">(Rs.<?php echo e(number_format($metrics['shipping_charges'], 2)); ?>)</td>
                            </tr>
                            <tr>
                                <td class="ps-4 text-danger">Less: GST</td>
                                <td class="text-end text-danger">(Rs.<?php echo e(number_format($metrics['gst'], 2)); ?>)</td>
                            </tr>
                            <tr>
                                <td class="ps-4 text-danger">Less: WH Income Tax</td>
                                <td class="text-end text-danger">(Rs.<?php echo e(number_format($metrics['wh_inc_tax'], 2)); ?>)</td>
                            </tr>
                            <tr>
                                <td class="ps-4 text-danger">Less: WH Sales Tax</td>
                                <td class="text-end text-danger">(Rs.<?php echo e(number_format($metrics['wh_sales_tax'], 2)); ?>)</td>
                            </tr>
                            <tr>
                                <td class="ps-4"><strong>Total Deductions</strong></td>
                                <td class="text-end"><strong class="text-danger">(Rs.<?php echo e(number_format($metrics['total_deductions'], 2)); ?>)</strong></td>
                            </tr>
                            
                            <!-- Net Revenue -->
                            <tr class="border-top border-bottom bg-success bg-opacity-10">
                                <td class="fw-bold fs-5 py-3"><i class="fas fa-coins me-2"></i>NET REVENUE</td>
                                <td class="text-end fw-bold fs-5 text-success py-3">Rs.<?php echo e(number_format($metrics['net_revenue'], 2)); ?></td>
                            </tr>
                            
                            <!-- Returns Impact -->
                            <?php if($metrics['returned_count'] > 0): ?>
                            <tr class="border-top">
                                <td colspan="2" class="fw-bold text-warning pt-3">RETURNS IMPACT</td>
                            </tr>
                            <tr>
                                <td class="ps-4">Returned Orders (<?php echo e($metrics['returned_count']); ?>)</td>
                                <td class="text-end text-warning">Rs.<?php echo e(number_format($metrics['returned_amount'], 2)); ?></td>
                            </tr>
                            <tr>
                                <td class="ps-4 small text-muted">Return Rate</td>
                                <td class="text-end small text-muted"><?php echo e(number_format($metrics['return_rate'], 2)); ?>%</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    
                    <div class="alert alert-info mt-4 mb-0">
                        <small>
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Note:</strong> Net Revenue is what you actually receive. Courier collects COD from customers, then deducts 
                            shipping charges, GST, and withholding taxes before paying you. Returns are excluded from calculations.
                        </small>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Stats -->
        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="fas fa-chart-pie me-2"></i>Quick Stats</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="small">Revenue per Order</span>
                            <strong>Rs.<?php echo e(number_format($metrics['avg_order_value'], 2)); ?></strong>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-success" style="width: 100%"></div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="small">Average Items per Order</span>
                            <strong><?php echo e($metrics['total_orders'] > 0 ? number_format($metrics['total_items'] / $metrics['total_orders'], 1) : 0); ?></strong>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-info" style="width: 75%"></div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="small">Deduction Rate</span>
                            <strong><?php echo e($metrics['gross_sales'] > 0 ? number_format(($metrics['total_deductions'] / $metrics['gross_sales']) * 100, 1) : 0); ?>%</strong>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-warning" style="width: <?php echo e($metrics['gross_sales'] > 0 ? ($metrics['total_deductions'] / $metrics['gross_sales']) * 100 : 0); ?>%"></div>
                        </div>
                    </div>
                    
                    <div>
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="small">Return Rate</span>
                            <strong class="text-warning"><?php echo e(number_format($metrics['return_rate'], 1)); ?>%</strong>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-danger" style="width: <?php echo e($metrics['return_rate']); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0"><i class="fas fa-lightbulb me-2"></i>Insights</h6>
                </div>
                <div class="card-body">
                    <?php if($metrics['return_rate'] > 10): ?>
                        <div class="alert alert-warning alert-sm mb-2">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            <small>High return rate detected (<?php echo e(number_format($metrics['return_rate'], 1)); ?>%). Consider reviewing product quality.</small>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($metrics['avg_order_value'] > 0): ?>
                        <div class="alert alert-info alert-sm mb-2">
                            <i class="fas fa-info-circle me-1"></i>
                            <small>Average order value: Rs.<?php echo e(number_format($metrics['avg_order_value'], 2)); ?></small>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($metrics['total_orders'] == 0): ?>
                        <div class="alert alert-secondary alert-sm mb-0">
                            <i class="fas fa-calendar-times me-1"></i>
                            <small>No orders in this period.</small>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Products Performance -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-trophy me-2 text-warning"></i>Top Selling Products</h5>
                </div>
                <div class="card-body">
                    <?php if(count($productPerformance) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover table-sm">
                                <thead class="table-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Product</th>
                                        <th class="text-end">Qty</th>
                                        <th class="text-end">Revenue</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $productPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td>
                                                <strong><?php echo e($item->product ? $item->product->name : 'Unknown'); ?></strong>
                                                <br><small class="text-muted"><?php echo e($item->order_count); ?> orders</small>
                                            </td>
                                            <td class="text-end">
                                                <span class="badge bg-primary"><?php echo e($item->total_quantity); ?></span>
                                            </td>
                                            <td class="text-end">
                                                <strong>Rs.<?php echo e(number_format($item->total_revenue, 2)); ?></strong>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info mb-0">
                            <i class="fas fa-info-circle me-2"></i>No product sales data available for this period.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-exclamation-triangle me-2 text-danger"></i>Most Returned Products</h5>
                </div>
                <div class="card-body">
                    <?php if(count($returnsAnalysis) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover table-sm">
                                <thead class="table-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Product</th>
                                        <th class="text-end">Qty</th>
                                        <th class="text-end">Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $returnsAnalysis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td>
                                                <strong><?php echo e($item['product'] ? $item['product']->name : 'Unknown'); ?></strong>
                                                <br><small class="text-muted"><?php echo e($item['return_count']); ?> returns</small>
                                            </td>
                                            <td class="text-end">
                                                <span class="badge bg-danger"><?php echo e($item['total_quantity']); ?></span>
                                            </td>
                                            <td class="text-end">
                                                <strong>Rs.<?php echo e(number_format($item['total_value'], 2)); ?></strong>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-success mb-0">
                            <i class="fas fa-check-circle me-2"></i>No returns in this period. Great!
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Period Breakdown Chart -->
    <?php if(count($periodBreakdown) > 0): ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-chart-bar me-2"></i>Revenue Trend</h5>
                </div>
                <div class="card-body">
                    <canvas id="revenueChart" height="80"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
function toggleCustomDates() {
    const filterType = document.getElementById('filter_type').value;
    const startContainer = document.getElementById('start_date_container');
    const endContainer = document.getElementById('end_date_container');
    
    if (filterType === 'custom') {
        startContainer.style.display = 'block';
        endContainer.style.display = 'block';
    } else {
        startContainer.style.display = 'none';
        endContainer.style.display = 'none';
    }
}

<?php if(count($periodBreakdown) > 0): ?>
// Revenue Chart
const ctx = document.getElementById('revenueChart').getContext('2d');
const revenueChart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: <?php echo json_encode(array_column($periodBreakdown, 'label')); ?>,
        datasets: [{
            label: 'Revenue (Rs.)',
            data: <?php echo json_encode(array_column($periodBreakdown, 'revenue')); ?>,
            backgroundColor: 'rgba(75, 192, 192, 0.6)',
            borderColor: 'rgba(75, 192, 192, 1)',
            borderWidth: 1
        }, {
            label: 'Orders',
            data: <?php echo json_encode(array_column($periodBreakdown, 'orders')); ?>,
            backgroundColor: 'rgba(54, 162, 235, 0.6)',
            borderColor: 'rgba(54, 162, 235, 1)',
            borderWidth: 1,
            yAxisID: 'y1'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: true,
        interaction: {
            mode: 'index',
            intersect: false,
        },
        scales: {
            y: {
                type: 'linear',
                display: true,
                position: 'left',
                title: {
                    display: true,
                    text: 'Revenue (Rs.)'
                }
            },
            y1: {
                type: 'linear',
                display: true,
                position: 'right',
                title: {
                    display: true,
                    text: 'Orders'
                },
                grid: {
                    drawOnChartArea: false,
                }
            }
        },
        plugins: {
            legend: {
                display: true,
                position: 'top'
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        let label = context.dataset.label || '';
                        if (label) {
                            label += ': ';
                        }
                        if (context.datasetIndex === 0) {
                            label += 'Rs.' + context.parsed.y.toLocaleString();
                        } else {
                            label += context.parsed.y;
                        }
                        return label;
                    }
                }
            }
        }
    }
});
<?php endif; ?>
</script>

<style>
.alert-sm {
    padding: 0.5rem;
    font-size: 0.875rem;
}
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\jtest\resources\views/reports/index.blade.php ENDPATH**/ ?>