@extends('layouts.app')

@section('title', 'Show.blade.php')
@section('page-title', 'Show.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">{{ $rawMaterial->name }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Basic Information</h6>
                        <table class="table table-sm">
                            <tr>
                                <td><strong>Unit:</strong></td>
                                <td>{{ $rawMaterial->unit }}</td>
                            </tr>
                            <tr>
                                <td><strong>Current Stock:</strong></td>
                                <td>
                                    {{ $rawMaterial->current_stock }}
                                    <span class="badge bg-{{ $rawMaterial->current_stock <= $rawMaterial->min_stock_level ? 'warning' : 'success' }} ms-2">
                                        {{ $rawMaterial->current_stock <= $rawMaterial->min_stock_level ? 'Low Stock' : 'OK' }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Min Stock Level:</strong></td>
                                <td>{{ $rawMaterial->min_stock_level }}</td>
                            </tr>
                            <tr>
                                <td><strong>Cost per Unit:</strong></td>
                                <td>${{ number_format($rawMaterial->cost_per_unit, 2) }}</td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    <span class="badge bg-{{ $rawMaterial->is_active ? 'success' : 'secondary' }}">
                                        {{ $rawMaterial->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6>Description</h6>
                        <p>{{ $rawMaterial->description ?: 'No description provided.' }}</p>
                    </div>
                </div>

                <hr>

                <h6>Used in Products</h6>
                @if($rawMaterial->products->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>SKU</th>
                                    <th>Quantity Required</th>
                                    <th>Can Make</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($rawMaterial->products as $product)
                                    @php
                                        $required = $product->pivot->quantity_required;
                                        $available = $rawMaterial->current_stock;
                                        $canMake = floor($available / $required);
                                    @endphp
                                    <tr>
                                        <td>{{ $product->name }}</td>
                                        <td>{{ $product->sku }}</td>
                                        <td>{{ $product->pivot->quantity_required }}</td>
                                        <td>
                                            <span class="badge bg-{{ $canMake > 0 ? 'success' : 'danger' }}">
                                                {{ $canMake }} units
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="alert alert-info">This raw material is not used in any products.</div>
                @endif

                <div class="mt-4">
                    <a href="{{ route('raw-materials.edit', $rawMaterial) }}" class="btn btn-primary">Edit Raw Material</a>
                    <a href="{{ route('raw-materials.index') }}" class="btn btn-secondary">Back to Raw Materials</a>
                </div>
            </div>
        </div>
    </div>
</div>
                

    </div>
</div>
@endsection
