@extends('layouts.app')

@section('title', 'Show.blade.php')
@section('page-title', 'Show.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">{{ $product->name }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Basic Information</h6>
                        <table class="table table-sm">
                            <tr>
                                <td><strong>SKU:</strong></td>
                                <td>{{ $product->sku }}</td>
                            </tr>
                            <tr>
                                <td><strong>Price:</strong></td>
                                <td>${{ number_format($product->price, 2) }}</td>
                            </tr>
                            <tr>
                                <td><strong>Current Stock:</strong></td>
                                <td>
                                    {{ $product->current_stock }}
                                    <span class="badge bg-{{ $product->current_stock <= $product->min_stock_level ? 'warning' : 'success' }} ms-2">
                                        {{ $product->current_stock <= $product->min_stock_level ? 'Low Stock' : 'OK' }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Min Stock Level:</strong></td>
                                <td>{{ $product->min_stock_level }}</td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    <span class="badge bg-{{ $product->is_active ? 'success' : 'secondary' }}">
                                        {{ $product->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6>Description</h6>
                        <p>{{ $product->description ?: 'No description provided.' }}</p>
                    </div>
                </div>

                <hr>

                <h6>Raw Materials Required</h6>
                @if($product->rawMaterials->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Raw Material</th>
                                    <th>Unit</th>
                                    <th>Quantity Required</th>
                                    <th>Current Stock</th>
                                    <th>Can Make</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($product->rawMaterials as $rawMaterial)
                                    @php
                                        $required = $rawMaterial->pivot->quantity_required;
                                        $available = $rawMaterial->current_stock;
                                        $canMake = floor($available / $required);
                                    @endphp
                                    <tr>
                                        <td>{{ $rawMaterial->name }}</td>
                                        <td>{{ $rawMaterial->unit }}</td>
                                        <td>{{ $rawMaterial->pivot->quantity_required }}</td>
                                        <td>{{ $rawMaterial->current_stock }}</td>
                                        <td>{{ $canMake }} units</td>
                                        <td>
                                            <span class="badge bg-{{ $canMake > 0 ? 'success' : 'danger' }}">
                                                {{ $canMake > 0 ? 'Available' : 'Insufficient' }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="alert alert-info">No raw materials defined for this product.</div>
                @endif

                <div class="mt-4">
                    <a href="{{ route('products.edit', $product) }}" class="btn btn-primary">Edit Product</a>
                    <a href="{{ route('products.index') }}" class="btn btn-secondary">Back to Products</a>
                </div>
            </div>
        </div>
    </div>
</div>
                

    </div>
</div>
@endsection
