@extends('layouts.app')

@section('title', 'Create.blade.php')
@section('page-title', 'Create.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Product Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('products.store') }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Product Name *</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sku" class="form-label">SKU (Optional)</label>
                                <input type="text" class="form-control @error('sku') is-invalid @enderror" id="sku" name="sku" value="{{ old('sku') }}">
                                @error('sku')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="price" class="form-label">Price *</label>
                        <div class="input-group">
                            <span class="input-group-text">$</span>
                            <input type="number" step="0.01" min="0" class="form-control @error('price') is-invalid @enderror" id="price" name="price" value="{{ old('price') }}" required>
                        </div>
                        @error('price')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Stock availability is calculated automatically based on raw materials.</div>
                    </div>

                    <hr>
                    <h5>Raw Materials</h5>
                    <div id="raw-materials-container">
                        <div class="raw-material-row row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Raw Material</label>
                                <select name="raw_materials[0][raw_material_id]" class="form-select">
                                    <option value="">Select Raw Material</option>
                                    @foreach($rawMaterials as $rawMaterial)
                                        <option value="{{ $rawMaterial->id }}">{{ $rawMaterial->name }} ({{ $rawMaterial->unit }})</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Quantity Required</label>
                                <input type="number" step="0.01" min="0.01" name="raw_materials[0][quantity_required]" class="form-control" placeholder="0.00">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">&nbsp;</label>
                                <button type="button" class="btn btn-outline-danger d-block" onclick="removeRawMaterial(this)">Remove</button>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn btn-outline-primary" onclick="addRawMaterial()">
                        <i class="fas fa-plus me-2"></i>Add Raw Material
                    </button>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Create Product</button>
                        <a href="{{ route('products.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
let rawMaterialIndex = 1;

function addRawMaterial() {
    const container = document.getElementById('raw-materials-container');
    const newRow = document.createElement('div');
    newRow.className = 'raw-material-row row mb-3';
    newRow.innerHTML = `
        <div class="col-md-6">
            <label class="form-label">Raw Material</label>
            <select name="raw_materials[${rawMaterialIndex}][raw_material_id]" class="form-select">
                <option value="">Select Raw Material</option>
                @foreach($rawMaterials as $rawMaterial)
                    <option value="{{ $rawMaterial->id }}">{{ $rawMaterial->name }} ({{ $rawMaterial->unit }})</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">Quantity Required</label>
            <input type="number" step="0.01" min="0.01" name="raw_materials[${rawMaterialIndex}][quantity_required]" class="form-control" placeholder="0.00">
        </div>
        <div class="col-md-2">
            <label class="form-label">&nbsp;</label>
            <button type="button" class="btn btn-outline-danger d-block" onclick="removeRawMaterial(this)">Remove</button>
        </div>
    `;
    container.appendChild(newRow);
    rawMaterialIndex++;
}

function removeRawMaterial(button) {
    button.closest('.raw-material-row').remove();
}
</script>
                

    </div>
</div>
@endsection
