@extends('layouts.app')

@section('title', 'Show.blade.php')
@section('page-title', 'Show.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Order: {{ $order->shopify_order_id }}</h5>
            </div>
            @if($order->returned_at)
            <div class="alert alert-danger m-3 mb-0">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>This order has been returned!</strong>
                <p class="mb-0 mt-2">Return Date: {{ $order->returned_at->format('F d, Y, h:i A') }}</p>
                <p class="mb-0 small">Note: Inventory has been restored and this order should be excluded from P&L reports.</p>
            </div>
            @endif
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Order Information</h6>
                        <table class="table table-sm">
                            <tr>
                                <td><strong>Order ID:</strong></td>
                                <td>{{ $order->shopify_order_id }}</td>
                            </tr>
                            <tr>
                                <td><strong>Customer:</strong></td>
                                <td>{{ $order->customer_name }}</td>
                            </tr>
                            <tr>
                                <td><strong>Email:</strong></td>
                                <td>{{ $order->customer_email ?: 'N/A' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Total Amount:</strong></td>
                                <td>${{ number_format($order->total_amount, 2) }}</td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    @if($order->returned_at)
                                        <span class="badge bg-danger">
                                            <i class="fas fa-undo me-1"></i>Returned
                                        </span>
                                    @else
                                        <span class="badge bg-{{ $order->status === 'pending' ? 'warning' : ($order->status === 'processing' ? 'info' : ($order->status === 'delivered' ? 'success' : 'secondary')) }}">
                                            {{ ucfirst($order->status) }}
                                        </span>
                                    @endif
                                </td>
                            </tr>
                            @if($order->returned_at)
                            <tr>
                                <td><strong>Returned Date:</strong></td>
                                <td>
                                    <span class="text-danger">
                                        <i class="fas fa-calendar-times me-1"></i>{{ $order->returned_at->format('F d, Y') }}
                                    </span>
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <td><strong>Order Date:</strong></td>
                                <td>{{ $order->order_date->format('M d, Y') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6>Notes</h6>
                        <p>{{ $order->notes ?: 'No notes provided.' }}</p>
                    </div>
                </div>
                
                <hr>
                
                <div class="row">
                    <div class="col-12">
                        <h6>Courier Service Data</h6>
                        @if($order->net_amount)
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <tr>
                                        <td><strong>Order Total:</strong></td>
                                        <td>Rs.{{ number_format($order->total_amount, 2) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Shipping Charges:</strong></td>
                                        <td class="text-success">+ Rs.{{ number_format($order->shipping_charges, 2) }}</td>
                                    </tr>
                                    <tr class="table-light">
                                        <td><strong>Total with Shipping:</strong></td>
                                        <td><strong>Rs.{{ number_format($order->total_amount + $order->shipping_charges, 2) }}</strong></td>
                                    </tr>
                                    <tr>
                                        <td><strong>GST (Deduction):</strong></td>
                                        <td class="text-danger">- Rs.{{ number_format($order->gst, 2) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>WH Income Tax 2% (Deduction):</strong></td>
                                        <td class="text-danger">- Rs.{{ number_format($order->wh_inc_tax, 2) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>WH Sales Tax 2% (Deduction):</strong></td>
                                        <td class="text-danger">- Rs.{{ number_format($order->wh_sales_tax, 2) }}</td>
                                    </tr>
                                    <tr class="table-light">
                                        <td><strong>Total Deductions:</strong></td>
                                        <td><strong class="text-danger">- Rs.{{ number_format($order->gst + $order->wh_inc_tax + $order->wh_sales_tax, 2) }}</strong></td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><strong>Net Amount (You Receive):</strong></td>
                                        <td><strong class="text-success fs-5">Rs.{{ number_format($order->net_amount, 2) }}</strong></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Last Updated:</strong></td>
                                        <td><small class="text-muted">{{ $order->courier_data_updated_at->format('M d, Y H:i A') }}</small></td>
                                    </tr>
                                </table>
                            </div>
                        @else
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle"></i> 
                                <strong>Courier data not yet available.</strong><br>
                                <small>Import courier service data to see shipping costs, deductions, and net amount.</small>
                                @can('import-inventory')
                                <br><a href="{{ route('import.index') }}" class="btn btn-sm btn-outline-warning mt-2">
                                    <i class="fas fa-upload"></i> Import Courier Data
                                </a>
                                @endcan
                            </div>
                        @endif
                    </div>
                </div>

                <hr>

                <h6>Order Items</h6>
                @if($order->orderItems->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>SKU</th>
                                    <th>Quantity</th>
                                    <th>Unit Price</th>
                                    <th>Total Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($order->orderItems as $item)
                                    <tr>
                                        <td>{{ $item->product->name }}</td>
                                        <td>{{ $item->product->sku }}</td>
                                        <td>{{ $item->quantity }}</td>
                                        <td>${{ number_format($item->unit_price, 2) }}</td>
                                        <td>${{ number_format($item->total_price, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="alert alert-info">No items found for this order.</div>
                @endif

                @if(!empty($shortages))
                    <hr>
                    <h6 class="text-danger">Stock Shortages</h6>
                    <div class="alert alert-warning">
                        <strong>Warning:</strong> Insufficient raw material stock to process this order.
                        <ul class="mb-0 mt-2">
                            @foreach($shortages as $shortage)
                                <li>
                                    <strong>{{ $shortage['raw_material']->name }}:</strong> 
                                    Need {{ $shortage['required'] }} {{ $shortage['raw_material']->unit }}, 
                                    but only {{ $shortage['available'] }} {{ $shortage['raw_material']->unit }} available 
                                    (shortage: {{ $shortage['shortage'] }} {{ $shortage['raw_material']->unit }})
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="mt-4">
                    <a href="{{ route('orders.edit', $order) }}" class="btn btn-primary">Edit Order</a>
                    <a href="{{ route('orders.index') }}" class="btn btn-secondary">Back to Orders</a>
                    <!-- Order processing buttons hidden - focus on import and stock management only -->
                </div>
            </div>
        </div>
    </div>
</div>
                

    </div>
</div>
@endsection
