@extends('layouts.app')

@section('title', 'Returned Products')
@section('page-title', 'Returned Products')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2><i class="fas fa-undo me-2"></i>Returned Products Report</h2>
                <a href="{{ route('orders.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Orders
                </a>
            </div>
            <p class="text-muted">Summary of all returned orders and products for P&L reporting</p>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-warning bg-opacity-10 border-warning">
                <div class="card-body text-center">
                    <h3 class="text-warning">{{ count($returnedOrders) }}</h3>
                    <p class="mb-0 text-muted">Total Returned Orders</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info bg-opacity-10 border-info">
                <div class="card-body text-center">
                    <h3 class="text-info">{{ count($returnedProducts) }}</h3>
                    <p class="mb-0 text-muted">Unique Products</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger bg-opacity-10 border-danger">
                <div class="card-body text-center">
                    <h3 class="text-danger">
                        {{ array_sum(array_column($returnedProducts, 'total_quantity')) }}
                    </h3>
                    <p class="mb-0 text-muted">Total Items Returned</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-secondary bg-opacity-10 border-secondary">
                <div class="card-body text-center">
                    <h3 class="text-secondary">
                        Rs.{{ number_format(array_sum(array_map(function($p) {
                            return array_sum(array_column($p['orders'], 'total_price'));
                        }, $returnedProducts)), 2) }}
                    </h3>
                    <p class="mb-0 text-muted">Total Value</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Returned Products Summary Table -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title mb-0"><i class="fas fa-box-open me-2"></i>Returned Products by Item</h5>
        </div>
        <div class="card-body">
            @if(count($returnedProducts) > 0)
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Product Name</th>
                                <th>SKU</th>
                                <th class="text-end">Total Quantity Returned</th>
                                <th class="text-end">Number of Returns</th>
                                <th class="text-end">Total Value</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($returnedProducts as $productData)
                                @php
                                    $product = $productData['product'];
                                    $totalValue = array_sum(array_column($productData['orders'], 'total_price'));
                                @endphp
                                <tr>
                                    <td>
                                        <strong>{{ $product ? $product->name : 'Unknown Product' }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ $product ? $product->sku : 'N/A' }}</span>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-danger">{{ $productData['total_quantity'] }}</span>
                                    </td>
                                    <td class="text-end">
                                        {{ count($productData['orders']) }}
                                    </td>
                                    <td class="text-end">
                                        <strong>Rs.{{ number_format($totalValue, 2) }}</strong>
                                    </td>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-info" 
                                                data-bs-toggle="collapse" 
                                                data-bs-target="#details-{{ $product->id }}">
                                            <i class="fas fa-eye"></i> View Details
                                        </button>
                                    </td>
                                </tr>
                                <tr class="collapse" id="details-{{ $product->id }}">
                                    <td colspan="6" class="bg-light">
                                        <div class="p-3">
                                            <h6 class="mb-3">Return Details for {{ $product->name }}</h6>
                                            <table class="table table-sm table-bordered mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Order Reference</th>
                                                        <th>Customer</th>
                                                        <th>Return Date</th>
                                                        <th class="text-end">Quantity</th>
                                                        <th class="text-end">Unit Price</th>
                                                        <th class="text-end">Total</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($productData['orders'] as $orderData)
                                                        <tr>
                                                            <td>
                                                                <a href="{{ route('orders.show', $orderData['order']) }}">
                                                                    {{ $orderData['order']->shopify_order_id }}
                                                                </a>
                                                            </td>
                                                            <td>{{ $orderData['order']->customer_name }}</td>
                                                            <td>{{ $orderData['order']->returned_at->format('M d, Y') }}</td>
                                                            <td class="text-end">{{ $orderData['quantity'] }}</td>
                                                            <td class="text-end">Rs.{{ number_format($orderData['unit_price'], 2) }}</td>
                                                            <td class="text-end">Rs.{{ number_format($orderData['total_price'], 2) }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>No returned orders found. When orders are marked as returned, they will appear here.
                </div>
            @endif
        </div>
    </div>

    <!-- Returned Orders Timeline -->
    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0"><i class="fas fa-history me-2"></i>Returns Timeline</h5>
        </div>
        <div class="card-body">
            @if(count($returnedOrders) > 0)
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Order Reference</th>
                                <th>Customer</th>
                                <th>Order Date</th>
                                <th>Returned Date</th>
                                <th class="text-end">Total Amount</th>
                                <th class="text-end">Items Count</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($returnedOrders as $order)
                                <tr>
                                    <td>
                                        <a href="{{ route('orders.show', $order) }}">
                                            {{ $order->shopify_order_id }}
                                        </a>
                                    </td>
                                    <td>{{ $order->customer_name }}</td>
                                    <td>{{ $order->order_date->format('M d, Y') }}</td>
                                    <td>
                                        <span class="badge bg-warning">
                                            {{ $order->returned_at->format('M d, Y') }}
                                        </span>
                                    </td>
                                    <td class="text-end">Rs.{{ number_format($order->total_amount, 2) }}</td>
                                    <td class="text-end">{{ $order->orderItems->count() }}</td>
                                    <td>
                                        <span class="badge bg-danger">
                                            <i class="fas fa-undo me-1"></i>{{ ucfirst($order->status) }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>No returned orders in the timeline yet.
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.collapse {
    transition: all 0.3s ease;
}
</style>
@endsection

