@extends('layouts.app')

@section('title', 'Dashboard.blade.php')
@section('page-title', 'Dashboard.blade.php')

@section('content')
<div class="row">
    <div class="col-12">


    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
<div class="row">
    <!-- Inventory Status Cards -->
    <div class="col-12">
        <h3 class="mb-3">Raw Material Inventory Status</h3>
        <div class="row">
            @forelse($inventoryStatus as $item)
                <div class="col-md-4 mb-3">
                    <div class="card {{ $item['status'] === 'low' ? 'border-warning' : 'border-success' }}">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="card-title">{{ $item['raw_material']->name }}</h6>
                                    <p class="card-text text-muted">{{ $item['raw_material']->unit }}</p>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-{{ $item['status'] === 'low' ? 'warning' : 'success' }}">
                                        {{ $item['status'] === 'low' ? 'Low Stock' : 'OK' }}
                                    </span>
                                </div>
                            </div>
                            <div class="mt-2">
                                <small class="text-muted">
                                    Current: {{ $item['raw_material']->current_stock }} / 
                                    Min: {{ $item['raw_material']->min_stock_level }}
                                </small>
                                <div class="progress mt-1" style="height: 5px;">
                                    <div class="progress-bar bg-{{ $item['status'] === 'low' ? 'warning' : 'success' }}" 
                                         style="width: {{ $item['percentage'] }}%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="alert alert-info">No raw materials found. <a href="{{ route('raw-materials.create') }}">Add some raw materials</a> to get started.</div>
                </div>
            @endforelse
        </div>
    </div>

    <!-- Products That Can't Be Made -->
    @php
        $unavailableProducts = collect($lowStockProducts)->filter(function($product) {
            return $product['can_make'] === 0;
        });
    @endphp
    @if($unavailableProducts->count() > 0)
    <div class="col-12 mt-4">
        <h3 class="mb-3">Products That Can't Be Made</h3>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Product Name</th>
                        <th>SKU</th>
                        <th>Can Make</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($unavailableProducts as $product)
                        <tr>
                            <td>{{ $product['name'] }}</td>
                            <td>{{ $product['sku'] }}</td>
                            <td>{{ $product['can_make'] }} units</td>
                            <td>
                                <span class="badge bg-danger">Insufficient Materials</span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif

    <!-- Recent Orders -->
    <div class="col-12 mt-4">
        <h3 class="mb-3">Recent Imported Orders</h3>
        <p class="text-muted small">Orders imported from Shopify - used for inventory tracking only</p>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Order ID</th>
                        <th>Customer</th>
                        <th>Total Amount</th>
                        <th>Status</th>
                        <th>Order Date</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($recentOrders as $order)
                        <tr>
                            <td>{{ $order->shopify_order_id }}</td>
                            <td>{{ $order->customer_name }}</td>
                            <td>${{ number_format($order->total_amount, 2) }}</td>
                            <td>
                                <span class="badge bg-{{ $order->status === 'pending' ? 'warning' : ($order->status === 'processing' ? 'info' : 'success') }}">
                                    {{ ucfirst($order->status) }}
                                </span>
                            </td>
                            <td>{{ $order->order_date->format('M d, Y') }}</td>
                            <td>
                                <span class="text-muted small">Inventory deducted</span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">No orders found. <a href="{{ route('import.index') }}">Import some orders</a> to get started.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
                


    </div>
</div>
@endsection
