@extends('layouts.app')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')
<div class="row">
    <!-- Welcome Message -->
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-body">
                <h3 class="card-title">Welcome, {{ Auth::user()->name }}!</h3>
                <p class="card-text">
                    @if(Auth::user()->isAdmin())
                        You have full administrative access to the system.
                    @elseif(Auth::user()->isManager())
                        You have management access to inventory, products, and orders.
                    @else
                        You have limited access to the system.
                    @endif
                </p>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="col-12">
        <div class="row">
            @can('view-inventory')
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Inventory</h5>
                        <p class="card-text">Manage your inventory and raw materials</p>
                        <a href="{{ route('inventory.dashboard') }}" class="btn btn-primary">
                            View Inventory
                        </a>
                    </div>
                </div>
            </div>
            @endcan

            @can('view-products')
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Products</h5>
                        <p class="card-text">Manage your product catalog</p>
                        <a href="{{ route('products.index') }}" class="btn btn-success">
                            View Products
                        </a>
                    </div>
                </div>
            </div>
            @endcan

            @can('view-orders')
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Orders</h5>
                        <p class="card-text">View and manage orders</p>
                        <a href="{{ route('orders.index') }}" class="btn btn-info">
                            View Orders
                        </a>
                    </div>
                </div>
            </div>
            @endcan

            @can('import-inventory')
            <div class="col-md-3 mb-4">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <h5 class="card-title">Import</h5>
                        <p class="card-text">Import data from Excel files</p>
                        <a href="{{ route('import.index') }}" class="btn btn-warning">
                            Import Data
                        </a>
                    </div>
                </div>
            </div>
            @endcan
        </div>
    </div>

    <!-- Role Information -->
    <div class="col-12 mt-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Your Role & Permissions</h5>
                <div class="row">
                    <div class="col-md-6">
                        <h6>Current Role:</h6>
                        <span class="badge badge-{{ Auth::user()->isAdmin() ? 'danger' : (Auth::user()->isManager() ? 'primary' : 'secondary') }}">
                            @if(Auth::user()->isAdmin())
                                Administrator
                            @elseif(Auth::user()->isManager())
                                Manager
                            @else
                                User
                            @endif
                        </span>
                    </div>
                    <div class="col-md-6">
                        <h6>Key Permissions:</h6>
                        <div class="d-flex flex-wrap">
                            @if(Auth::user()->hasPermission('view-inventory'))
                                <span class="badge badge-success mr-1 mb-1">View Inventory</span>
                            @endif
                            @if(Auth::user()->hasPermission('manage-inventory'))
                                <span class="badge badge-success mr-1 mb-1">Manage Inventory</span>
                            @endif
                            @if(Auth::user()->hasPermission('view-products'))
                                <span class="badge badge-success mr-1 mb-1">View Products</span>
                            @endif
                            @if(Auth::user()->hasPermission('create-products'))
                                <span class="badge badge-success mr-1 mb-1">Create Products</span>
                            @endif
                            @if(Auth::user()->hasPermission('view-orders'))
                                <span class="badge badge-success mr-1 mb-1">View Orders</span>
                            @endif
                            @if(Auth::user()->hasPermission('import-inventory'))
                                <span class="badge badge-success mr-1 mb-1">Import Data</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
