<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->decimal('shipping_charges', 10, 2)->nullable()->after('total_amount');
            $table->decimal('gst', 10, 2)->nullable()->after('shipping_charges');
            $table->decimal('wh_inc_tax', 10, 2)->nullable()->after('gst')->comment('Withholding Income Tax 2%');
            $table->decimal('wh_sales_tax', 10, 2)->nullable()->after('wh_inc_tax')->comment('Withholding Sales Tax 2%');
            $table->decimal('net_amount', 10, 2)->nullable()->after('wh_sales_tax')->comment('Final amount from courier service');
            $table->timestamp('courier_data_updated_at')->nullable()->after('net_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'shipping_charges',
                'gst',
                'wh_inc_tax',
                'wh_sales_tax',
                'net_amount',
                'courier_data_updated_at'
            ]);
        });
    }
};
