<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Order extends Model
{
    protected $fillable = [
        'shopify_order_id',
        'customer_name',
        'customer_email',
        'total_amount',
        'status',
        'order_date',
        'notes',
        'shipping_charges',
        'gst',
        'wh_inc_tax',
        'wh_sales_tax',
        'net_amount',
        'courier_data_updated_at',
        'returned_at'
    ];

    protected $casts = [
        'total_amount' => 'decimal:2',
        'order_date' => 'date',
        'shipping_charges' => 'decimal:2',
        'gst' => 'decimal:2',
        'wh_inc_tax' => 'decimal:2',
        'wh_sales_tax' => 'decimal:2',
        'net_amount' => 'decimal:2',
        'courier_data_updated_at' => 'datetime',
        'returned_at' => 'datetime'
    ];

    public function orderItems(): HasMany
    {
        return $this->hasMany(OrderItem::class);
    }
}
