# Reports & Analytics Feature Guide

## Overview

A comprehensive reporting system has been implemented that provides detailed P&L (Profit & Loss) analysis, sales metrics, product performance tracking, and returns analysis with flexible date filtering.

## Features

### 1. **Date Filtering Options**
- **Daily** - View today's performance
- **Weekly** - Current week analysis
- **Monthly** - Month-to-date metrics (default)
- **Yearly** - Year-to-date overview
- **Custom Range** - Specify exact start and end dates

### 2. **Key Performance Indicators (KPIs)**

Four main metric cards displayed at the top:

#### Net Revenue
- Total amount you actually receive after all deductions
- Includes: Gross Sales + Shipping Charges - GST - Withholding Taxes
- Excludes: Returned orders

#### Total Orders
- Count of active orders (non-returned) in the period
- Shows total items sold

#### Average Order Value
- Revenue per transaction
- Calculated as: Gross Sales / Number of Orders

#### Returns
- Number of returned orders
- Return rate percentage

### 3. **Profit & Loss Statement**

Complete P&L breakdown showing:

**REVENUE SECTION:**
- Gross Sales (from orders)
- Add: Shipping Charges
- = Total Sales Revenue

**DEDUCTIONS SECTION:**
- Less: GST (Goods & Services Tax)
- Less: WH Income Tax (Withholding Income Tax)
- Less: WH Sales Tax (Withholding Sales Tax)
- = Total Deductions

**NET REVENUE:**
- Final amount you receive
- **This is your actual revenue!**

**RETURNS IMPACT (if applicable):**
- Shows returned order value
- Return rate percentage
- Helps understand impact on business

### 4. **Product Performance Analysis**

#### Top Selling Products
- Top 10 products by revenue
- Shows:
  - Product name
  - Quantity sold
  - Total revenue generated
  - Number of orders containing this product

#### Most Returned Products
- Top 10 most returned products
- Shows:
  - Product name
  - Quantity returned
  - Value of returns
  - Number of return instances

**Use this data to:**
- Identify bestsellers
- Spot problem products with high returns
- Make inventory decisions
- Evaluate product quality issues

### 5. **Quick Stats Panel**

Additional metrics:
- **Revenue per Order** - Average revenue per transaction
- **Average Items per Order** - How many products per order
- **Deduction Rate** - Percentage of revenue lost to taxes/fees
- **Return Rate** - Percentage of orders returned

Includes visual progress bars for easy comparison.

### 6. **Insights Panel**

Automated business insights:
- ⚠️ **High Return Alert** - If return rate exceeds 10%
- ℹ️ **Average Order Value** - Shows your typical order size
- 📅 **No Orders Notice** - If no orders in selected period

### 7. **Revenue Trend Chart**

Interactive chart showing:
- **Bar Chart** - Revenue per period
  - Yearly view: Shows monthly data
  - Monthly/Custom view: Shows daily data
- **Line/Bar Chart** - Order count per period
- **Dual Y-axis** - Revenue (left) and Orders (right)

**Benefits:**
- Spot trends and patterns
- Identify peak sales periods
- Compare revenue and order volume
- Plan inventory and staffing

## How to Use

### Accessing Reports

1. Click **"Reports"** in the main navigation menu
2. Page loads with current month data by default

### Filtering Reports

#### For Today's Data:
1. Select **"Today"** from Report Period dropdown
2. Click **"Apply Filter"**

#### For This Week:
1. Select **"This Week"**
2. Click **"Apply Filter"**

#### For This Month:
1. Select **"This Month"**
2. Click **"Apply Filter"**

#### For This Year:
1. Select **"This Year"**
2. Click **"Apply Filter"**
3. Chart shows monthly breakdown

#### For Custom Date Range:
1. Select **"Custom Range"**
2. Pick Start Date
3. Pick End Date
4. Click **"Apply Filter"**

### Understanding the Numbers

#### What is Net Revenue?
**Net Revenue** = Money you actually receive

**Formula:**
```
Gross Sales 
+ Shipping Charges 
- GST 
- Withholding Income Tax 
- Withholding Sales Tax 
= NET REVENUE
```

**Example:**
- Gross Sales: Rs. 10,000
- Shipping: Rs. 500
- GST: Rs. 200
- WH Inc Tax: Rs. 100
- WH Sales Tax: Rs. 50

**Net Revenue = 10,000 + 500 - 200 - 100 - 50 = Rs. 10,150**

#### What are Returns Excluded?

Yes! Returned orders are **automatically excluded** from all revenue calculations.

This means:
- ✅ Revenue shows only actual sales
- ✅ No false profits from returned orders
- ✅ Accurate financial picture
- ✅ Returns tracked separately for analysis

#### What is Return Rate?

**Return Rate** = (Returned Orders / Total Orders Including Returns) × 100

**Example:**
- Active Orders: 90
- Returned Orders: 10
- Total Orders: 100
- Return Rate: (10/100) × 100 = **10%**

**Industry Standards:**
- < 5% = Excellent
- 5-10% = Good
- 10-20% = Concerning
- > 20% = Critical - investigate immediately

## Report Interpretations

### Scenario 1: High Return Rate

**If return rate > 10%:**

**Actions to Take:**
1. Review "Most Returned Products" table
2. Check for quality issues
3. Verify product descriptions are accurate
4. Consider customer feedback
5. Evaluate shipping/packaging quality

### Scenario 2: Declining Average Order Value

**If AOV is decreasing:**

**Actions to Take:**
1. Implement upselling strategies
2. Create product bundles
3. Offer free shipping thresholds
4. Review pricing strategy
5. Add complementary products

### Scenario 3: High Deduction Rate

**If deduction rate > 15%:**

**Actions to Take:**
1. Verify tax calculations are correct
2. Review courier service agreements
3. Consider pricing adjustments to cover deductions
4. Consult with accountant on tax optimization

### Scenario 4: Revenue Trend Declining

**If revenue chart shows downward trend:**

**Actions to Take:**
1. Review marketing efforts
2. Check inventory availability
3. Analyze seasonal patterns
4. Evaluate competition
5. Consider promotional campaigns

## Data Sources

### Where does this data come from?

All data is pulled from your existing database:

**Orders Table:**
- Gross sales amounts
- Shipping charges
- Tax deductions
- Order dates
- Return dates

**Order Items Table:**
- Product quantities
- Product prices
- Order compositions

**Products Table:**
- Product names
- SKUs

**Exclusions:**
- Any order with `returned_at` timestamp is excluded from revenue
- Returns are tracked separately

## Technical Details

### Date Range Calculations

**Daily:**
- Start: Today at 00:00:00
- End: Today at 23:59:59

**Weekly:**
- Start: Monday of current week
- End: Sunday of current week

**Monthly:**
- Start: 1st day of current month
- End: Last day of current month

**Yearly:**
- Start: January 1st
- End: December 31st

**Custom:**
- Start: Selected date at 00:00:00
- End: Selected date at 23:59:59

### Performance Considerations

- Reports use optimized database queries
- Product tables limited to top 10
- Chart data aggregated appropriately
- Queries filter on indexed `order_date` column

### Permissions Required

**To access Reports:**
- User must have `view-orders` permission
- Managers and Admins have access by default

## Best Practices

### 1. Regular Review Schedule

**Daily:**
- Check today's sales
- Monitor order volume

**Weekly:**
- Review week's performance
- Check return rates

**Monthly:**
- Complete P&L analysis
- Product performance review
- Returns analysis

**Yearly:**
- Annual trends
- Long-term planning

### 2. Using Reports for Decisions

**Inventory Planning:**
- Use top products to plan stock
- Avoid overstocking returned products

**Pricing Strategy:**
- Factor deduction rates into pricing
- Ensure margins cover all costs

**Product Development:**
- Invest in bestsellers
- Improve or discontinue problem products

**Marketing:**
- Promote high-performers
- Bundle slow-moving items with bestsellers

### 3. Financial Planning

**Budget Forecasting:**
- Use historical trends
- Account for seasonal variations
- Factor in return rates

**Cash Flow Management:**
- Plan for tax deductions
- Account for shipping costs
- Budget for returns/refunds

## Exporting Reports

**Coming Soon:**
- CSV export for spreadsheet analysis
- PDF export for presentations
- Email scheduled reports
- Custom report builder

## Common Questions

### Q: Why doesn't net revenue match my bank statement?

**A:** Net revenue is calculated from order data. Bank statements may have:
- Timing differences (when payments clear)
- Bank fees not tracked in system
- Refunds for returns
- Payment gateway fees

**Solution:** Reconcile with bank statements regularly.

### Q: Why is today's revenue zero?

**A:** Possible reasons:
- No orders placed today
- Orders not yet imported
- Orders still being processed
- All orders were returned

**Solution:** Check orders page to verify.

### Q: Can I see returns separately?

**A:** Yes! 
1. Go to Orders → View Returns
2. Or check "Returns Impact" section in P&L
3. View "Most Returned Products" table

### Q: How do I exclude certain orders?

**A:** Currently, only returned orders are excluded. For custom exclusions, you would need to mark orders as returned or filter them manually.

### Q: Can I see individual order details?

**A:** Yes!
1. Go to Orders page
2. Click on any order reference number
3. View complete order details

### Q: What if my deductions are wrong?

**A:** 
1. Verify courier data was imported correctly
2. Check Orders → Import → Courier Data tab
3. Re-import if necessary
4. Values are pulled from `gst`, `wh_inc_tax`, `wh_sales_tax` fields

## Troubleshooting

### Issue: Chart not displaying

**Solution:**
- Refresh the page
- Check if there's data in the selected period
- Try a different date range
- Check browser console for errors

### Issue: Numbers seem incorrect

**Solution:**
1. Verify all orders are imported
2. Check if courier data is imported
3. Ensure returns are marked properly
4. Review date filter selection

### Issue: Page loading slowly

**Solution:**
- Use shorter date ranges
- Yearly view for long periods
- Clear browser cache
- Check database performance

## Future Enhancements

Potential features being considered:

1. **Profit Margin Analysis**
   - Include raw material costs
   - Calculate gross profit
   - Show profit margins per product

2. **Customer Analytics**
   - Customer lifetime value
   - Repeat customer rate
   - Customer segments

3. **Comparative Analysis**
   - Compare periods (month-over-month)
   - Year-over-year growth
   - Benchmark against targets

4. **Advanced Filtering**
   - Filter by product category
   - Filter by customer segment
   - Filter by order status

5. **Automated Insights**
   - AI-powered recommendations
   - Anomaly detection
   - Predictive analytics

6. **Export & Sharing**
   - PDF reports
   - CSV exports
   - Email scheduling
   - Dashboard widgets

## Related Documentation

- [RETURNS_IMPLEMENTATION_GUIDE.md](RETURNS_IMPLEMENTATION_GUIDE.md) - How returns work
- [ORDER_IMPORT_GUIDE.md](ORDER_IMPORT_GUIDE.md) - Importing orders
- [FOCUSED_ON_STOCK_MANAGEMENT.md](FOCUSED_ON_STOCK_MANAGEMENT.md) - Inventory management

## Support

For questions or issues:
1. Check this guide first
2. Review related documentation
3. Check sample data calculations
4. Verify data was imported correctly
5. Review Laravel logs at `storage/logs/laravel.log`

---

**Remember:** Reports are only as good as the data you input. Ensure:
- ✅ All orders are imported regularly
- ✅ Courier data is updated
- ✅ Returns are marked promptly
- ✅ Product information is accurate

Good reporting leads to good decisions! 📊

