# Inventory Management System

A Laravel-based web application for managing inventory of raw materials and end products, with automatic calculation of raw material requirements based on orders imported from Shopify.

## Features

### Core Functionality
- **Raw Material Management**: Track raw materials with current stock, minimum levels, and cost per unit
- **Product Management**: Manage end products with SKU, pricing, and stock levels
- **Product-Raw Material Relationships**: Define how much raw material each product requires
- **Order Management**: Import and manage orders from Shopify via Excel files
- **Inventory Calculation**: Automatically calculate raw material consumption based on orders
- **Stock Monitoring**: Real-time monitoring of low stock levels for both raw materials and products

### Key Features
- **Excel Import**: Import Shopify orders from Excel files (.xlsx, .xls, .csv)
- **Inventory Dashboard**: Overview of stock levels and recent orders
- **Stock Alerts**: Visual indicators for low stock levels
- **Order Processing**: Process orders and automatically update raw material inventory
- **Responsive Design**: Modern, mobile-friendly interface using Bootstrap 5

## Installation

### Prerequisites
- PHP 8.1 or higher
- Composer
- MySQL/SQLite database
- Web server (Apache/Nginx) or PHP built-in server

### Setup Instructions

1. **Clone or download the project**
   ```bash
   cd jtest
   ```

2. **Install dependencies**
   ```bash
   composer install
   ```

3. **Environment setup**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

4. **Database configuration**
   - Update `.env` file with your database credentials
   - For SQLite (default): The database file will be created automatically
   - For MySQL: Create a database and update the `.env` file

5. **Run migrations and seeders**
   ```bash
   php artisan migrate
   php artisan db:seed --class=InventorySeeder
   ```

6. **Start the development server**
   ```bash
   php artisan serve
   ```

7. **Access the application**
   - Open your browser and go to `http://localhost:8000`

## Usage

### Getting Started

1. **Add Raw Materials**
   - Navigate to "Raw Materials" in the sidebar
   - Click "Add Raw Material" to add ingredients like lotion base, bottles, labels, etc.
   - Set current stock, minimum levels, and cost per unit

2. **Create Products**
   - Go to "Products" section
   - Add your end products (e.g., "Moisturizing Lotion")
   - Define which raw materials each product uses and in what quantities

3. **Import Orders**
   - Use the "Import Orders" section to upload Shopify export files
   - The system will automatically create products if they don't exist
   - Orders will be processed and inventory will be calculated

4. **Monitor Inventory**
   - Check the dashboard for overall inventory status
   - View low stock alerts for both raw materials and products
   - Process orders to update inventory levels

### Example Workflow

1. **Setup**: Add raw materials (e.g., 10 liters of lotion base, 100 bottles, 500 labels)
2. **Product Definition**: Create "Moisturizing Lotion" product requiring:
   - 0.25 liters of lotion base per bottle
   - 1 bottle per product
   - 1 label per product
3. **Order Import**: Import Shopify orders with 4 bottles of lotion
4. **Processing**: System calculates and deducts:
   - 1 liter of lotion base (4 × 0.25)
   - 4 bottles
   - 4 labels
5. **Monitoring**: Dashboard shows updated stock levels and alerts

## File Structure

```
app/
├── Http/Controllers/
│   ├── InventoryController.php    # Main inventory management
│   ├── ProductController.php      # Product CRUD operations
│   ├── RawMaterialController.php  # Raw material CRUD operations
│   ├── OrderController.php        # Order management
│   └── ImportController.php       # Excel import functionality
├── Models/
│   ├── Product.php               # Product model
│   ├── RawMaterial.php           # Raw material model
│   ├── Order.php                 # Order model
│   ├── OrderItem.php             # Order item model
│   └── ProductRawMaterial.php    # Pivot model
└── Services/
    ├── InventoryService.php      # Inventory calculation logic
    └── ImportService.php         # Excel import processing

database/migrations/              # Database schema definitions
resources/views/                  # Blade templates
routes/web.php                   # Application routes
```

## API Endpoints

### Inventory Management
- `GET /` - Dashboard
- `GET /inventory/raw-materials` - Raw materials overview
- `GET /inventory/products` - Products overview
- `POST /inventory/add-stock` - Add stock to raw material
- `GET /inventory/orders/{order}/check-stock` - Check order stock availability
- `POST /inventory/orders/{order}/process` - Process order and update inventory

### CRUD Operations
- `GET|POST /products` - Product management
- `GET|POST /raw-materials` - Raw material management
- `GET|POST /orders` - Order management

### Import/Export
- `GET /import` - Import form
- `POST /import/excel` - Process Excel file
- `GET /import/template` - Download sample template

## Configuration

### Environment Variables
- `DB_CONNECTION` - Database type (sqlite, mysql)
- `DB_DATABASE` - Database name or file path
- `DB_USERNAME` - Database username (MySQL)
- `DB_PASSWORD` - Database password (MySQL)

### File Upload Limits
- Maximum file size: 10MB
- Supported formats: .xlsx, .xls, .csv

## Troubleshooting

### Common Issues

1. **Database Connection Error**
   - Check your `.env` file database configuration
   - Ensure database exists and credentials are correct

2. **Excel Import Fails**
   - Verify file format is supported (.xlsx, .xls, .csv)
   - Check file size is under 10MB
   - Ensure file has proper column headers

3. **Permission Errors**
   - Ensure storage and bootstrap/cache directories are writable
   - Run `php artisan storage:link` if needed

### Support

For issues or questions, please check the Laravel documentation or create an issue in the project repository.

## License

This project is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).